/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson.decoder;

import com.iccube.bson.ic3BsonBytesBuffer;
import org.bson.types.Decimal128;

public class ic3BsonDecimal128Decoder implements ic3BsonDecoder
{
    @Override
    public void skipValue(ic3BsonBytesBuffer array)
    {
        array.skip(8);
    }

    @Override
    public void decodeValue(ic3BsonBytesBuffer array, ic3BsonObjectBuilder rowBuilder, String fieldName)
    {
        long low = array.getLong();
        long high = array.getLong();
        rowBuilder.setValue(fieldName, Decimal128.fromIEEE754BIDEncoding(high, low).bigDecimalValue());
    }
}
