/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package com.iccube.bson.decoder;

import com.iccube.bson.ic3BsonBytesBuffer;
import com.iccube.bson.ic3BsonType;
import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdComparableArray;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ic3BsonArrayDecoder implements ic3BsonDecoder
{
    @Override
    public void skipValue(ic3BsonBytesBuffer array)
    {
        int size = array.getInt() - 4;
        array.skip(size);
    }

    @Override
    public void decodeValue(ic3BsonBytesBuffer array, ic3BsonObjectBuilder rowBuilder, String fieldName)
    {
        ic3BsonType type;
        array.skip(4);

        ArrayBuilder arrayBuilder = new ArrayBuilder(fieldName);
        while ((type = array.getType()) != ic3BsonType.END_OF_DOCUMENT)
        {
            array.skipFieldName(); // we really don't care on the field name
            if (type.isContainer())
            {
                type.getDecoder().decodeValue(array, arrayBuilder, "_");
            }
            else
            {
                final ic3BsonDecoder decoder = type.getDecoder();
                decoder.decodeValue(array, arrayBuilder, "_");
            }
        }
        arrayBuilder.setValues(rowBuilder);
    }

    private static class ArrayBuilder implements ic3BsonObjectBuilder
    {
        // debug purpose
        private String fieldName;

        private ArrayList<Comparable> list = new ArrayList<>();

        private Map<String, ArrayBuilder> el = new HashMap<>();

        public ArrayBuilder(String fieldName)
        {
            this.fieldName = fieldName;
        }

        @Override
        public ic3BsonObjectBuilder getForChild(String fieldName)
        {
            return el.computeIfAbsent(fieldName, k -> new ArrayBuilder(fieldName));
        }

        @Override
        public void setValue(String fieldName, Comparable value)
        {
            list.add(value);
        }

        public void setValues(ic3BsonObjectBuilder rowBuilder)
        {
            if (!CdCollections.emptyOrWithNulls(list))
            {
                rowBuilder.setValue(fieldName, new CdComparableArray(list.toArray(new Comparable[0])));
            }
            el.forEach((childName, builder) -> {
                final ic3BsonObjectBuilder rb = rowBuilder.getForChild(childName);
                if (rb != null)
                {
                    builder.setValues(rb);
                }
            });
        }
    }

}
