package crazydev.iccube.plugin.tableAggregator;

import crazydev.iccube.cluster.node.facts.IFactTableContext;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregator;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactsTableRow;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SumDoubleRows implements IOlapFactTableAggregatorFactory
{
    @Override
    public IOlapFactTableAggregator newInstance()
    {
        return new IOlapFactTableAggregator()
        {
            private boolean isInDebugMode;

            private String debugInfo = "";

            private List<Integer> positions;

            private double sum = 0;

            @Override
            public String getName()
            {
                return "Test";
            }

            @Override
            public void init(IFactTableContext context, String measureName, String factColumnName)
            {
                isInDebugMode = context.isDebug();
                sum = 0;

                positions = Arrays.stream(context.getAllColumns())
                        .filter(c -> c != null && c.getFactDataType().isFloatDouble())
                        .map(c -> context.getFromColumnName(c.getId().getFactColumnName()))
                        .toList();

                if (isInDebugMode && !positions.isEmpty())
                {
                    debugInfo = Arrays.stream(context.getAllColumns())
                                        .filter(c -> c != null && c.getFactDataType().isFloatDouble())
                                        .map(c -> c.getId().getFactColumnName())
                                        .collect(Collectors.joining("\t")) + "\n";
                }
            }

            @Override
            public boolean onRow(int rowNumber, IOlapFactsTableRow row)
            {
                final int size = positions.size();
                for (int i = 0; i < size; i++)
                {
                    Integer colIdx = positions.get(i);
                    final Double aDouble = row.getAsDouble(colIdx);
                    if (aDouble != null)
                    {
                        sum += aDouble;
                    }
                    if (isInDebugMode)
                    {
                        debugInfo += sum + ((i >= size - 1) ? "" : "\t");
                    }
                }
                if (isInDebugMode && !positions.isEmpty())
                {
                    debugInfo += "\n";
                }
                return true;
            }

            @Override
            public OlapScalarEntity asScalarEntity()
            {
                if (isInDebugMode)
                {
                    return new OlapStringEntity(debugInfo);
                }
                return new OlapNumericEntity(sum);
            }
        };
    }
}
