package crazydev.iccube.plugin.tableAggregator;

import crazydev.iccube.cluster.node.facts.IFactTableContext;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregator;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactsTableRow;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import org.jetbrains.annotations.Nullable;

public class OrderColumns implements IOlapFactTableAggregator
{
    Long2LongMap map = new Long2LongOpenHashMap();

    private int keyIdx;

    private int valueIdx;

    @Override
    public String getName()
    {
        return "";
    }

    @Override
    public void init(IFactTableContext context, String measureName, String factColumnName)
    {
        map.clear();

        keyIdx = context.getFromColumnName("WH_CUST_ID");
        valueIdx = context.getFromColumnName("INS_TRN_EndTime");

    }

    @Override
    public boolean onRow(int rowNumber, IOlapFactsTableRow row)
    {
        final long key = row.getQuickLong(keyIdx);
        final long value = row.getQuickDateTimeMillis(valueIdx);

        final long existing = map.get(key);
        if (value > existing)
        {
            map.put(key, value);
        }
        return true;
    }

    @Override
    public @Nullable OlapScalarEntity asScalarEntity()
    {
        return asNumericEntity(map.size());
    }
}
