/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapTimeDimensionWithDayOfYear extends OlapTimeDimensionWith
{
    public static final String NAME = "WithDayOfYear";

    public OlapTimeDimensionWithDayOfYear()
    {
        super(NAME);
    }

    @Override
    int minValue()
    {
        return 1;
    }

    @Override
    int maxValue()
    {
        return 366;
    }

    @Override
    protected LocalDateTime apply(LocalDateTime time, OlapNumericEntity[] parameters)
    {
        final int dayOfYear = Math.min(time.dayOfYear().getMaximumValue(), firstAsInteger(parameters));
        return time.withDayOfYear(dayOfYear);
    }

    @Override
    protected LocalDate apply(LocalDate time, OlapNumericEntity[] parameters)
    {
        final int dayOfYear = Math.min(time.dayOfYear().getMaximumValue(), firstAsInteger(parameters));
        return time.withDayOfYear(dayOfYear);
    }

    @Override
    protected OlapLevelType getLevelChanged()
    {
        return OlapLevelType.DAY;
    }

}
