/*
 * Copyright 2014 - 2017 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapTimeDimensionGetWeekOfYear extends OlapTimeDimensionGet
{
    public static final String NAME = "WeekOfYear";

    public OlapTimeDimensionGetWeekOfYear()
    {
        super(NAME);
    }

    @Override
    protected int apply(LocalDateTime time)
    {
        return time.getWeekOfWeekyear();
    }

    @Override
    protected int apply(LocalDate time)
    {
        return time.getWeekOfWeekyear();
    }

    @Override
    public boolean isScalar()
    {
        return false;
    }
}
