/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTimeDimensionDayOfWeekOfFunction extends OlapTimeDimensionFunction
{
    OlapTimeDimensionDayOfWeekOfFunction(String name)
    {
        super(name, ARGS_2);
    }

    OlapTimeDimensionDayOfWeekOfFunction(String name, boolean _3args)
    {
        super(name, _3args ? ARGS_3 : ARGS_2);
    }

    @Nullable
    @Override
    protected String validateParameter(int i, OlapNumericEntity parameter)
    {
        if (i == 1)
        {
            final int asInt = parameter.intValue();
            if (asInt < 1 || asInt > 7)
            {

                return "Weekday parameter should be between 1 (Monday) and 7 (Sunday)";

            }
        }

        return null;
    }
}
