/*
 * Copyright 2014 - 2017 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.pub.utils.ic3DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import java.util.function.Predicate;

/**
 * icCube function to navigate in the time dimension
 */
public class OlapDatesQtdTimeDimensionFunction extends OlapDatesTimeDimensionFunction
{
    public static final String NAME = "DatesQtd";

    public OlapDatesQtdTimeDimensionFunction()
    {
        super(NAME);
    }

    @Override
    protected Predicate<OlapMember> filter(LocalDateTime time)
    {
        final int quarter = ic3DateTime.getQuarter(time);
        return (member) -> ic3DateTime.getQuarter((LocalDateTime) member.getKeyValue()) == quarter;
    }

    @Override
    protected Predicate<OlapMember> filter(LocalDate time)
    {
        final int quarter = ic3DateTime.getQuarter(time);
        return (member) -> ic3DateTime.getQuarter((LocalDate) member.getKeyValue()) == quarter;
    }

    protected OlapLevelType getLevelChanged()
    {
        return OlapLevelType.QUARTER;
    }
}
