/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

/**
 * icCube function to navigate in the time dimension
 */
public class OlapDatesEndPeriodTimeDimensionFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "dtEndPeriod";

    protected static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1);

    public OlapDatesEndPeriodTimeDimensionFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapMember member = args.toMember(context, 0);
        if (member.isMdxNull())
        {
            return asEmpty();
        }
        final OlapLevelType levelType = member.getLevel().getLevelType();
        if (levelType == null)
        {
            return onFunctionError(context, OlapErrorCode.TYPE_MISMATCH, "time level", "no level type");
        }
        final Comparable key = member.getKeyValue();

        if (key instanceof LocalDate)
        {
            LocalDate localDate = (LocalDate) key;
            final LocalDate nextDate = levelType.getNextDate(localDate.toLocalDateTime(LocalTime.MIDNIGHT)).toLocalDate();
            return new OlapDateEntity(nextDate);
        }
        if (key instanceof LocalDateTime)
        {
            LocalDateTime localDate = (LocalDateTime) key;
            return new OlapDateTimeEntity(levelType.getNextDate(localDate));
        }
        return onFunctionError(context, OlapErrorCode.TYPE_MISMATCH, "Member with a LocalDate/LocalDateTime key", key.getClass().getName());
    }
}
