/*
 * Copyright 2014 - 2017 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseNumericStatisticalFunction;
import crazydev.iccube.plugin.function.OlapSetCalculatorOneExpression;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import org.apache.commons.math3.stat.StatUtils;

public class OlapPercentileFunction extends OlapBaseNumericStatisticalFunction
{
    public static final String NAME = "Percentile";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(3)
    {
        @Override
        public boolean isLambda(int pos)
        {
            return pos == 1;
        }
    };

    public OlapPercentileFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    protected OlapSetCalculatorOneExpression createCalculator(GFContext context, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args)
    {
        final double percentile = args.toDouble(context, 2);
        if (percentile <= 0.0 || percentile > 100.0)
        {
            return onFunctionArgTypeMismatchError(context, 2, "numeric between 0.0 and 100", /* !arg */ Double.toString(percentile));
        }

        return new OlapSetCalculatorOneExpression()
        {
            private final DoubleArrayList values = new DoubleArrayList();

            @Override
            public void addValue(double value)
            {
                context.assertNotCancelling(NAME);

                values.add(value);
            }

            @Override
            public boolean isResultEmpty()
            {
                return values.isEmpty();
            }

            @Override
            public double calculate()
            {
                return StatUtils.percentile(values.toDoubleArray(), percentile);
            }
        };
    }


}