/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.iccube.plugin.function.OlapPluginOneExprStatFunctions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;

/**
 * Returns the Historical Value At Risk.
 * <pre>
 * HVaR( Set_Expression , Numeric_Expression, 5%)
 * </pre>
 */
public class OlapHVaRFunction implements OlapPluginOneExprStatFunctions
{
    private final DoubleArrayList values = new DoubleArrayList();

    @Override
    public OlapHVaRFunction newInstance()
    {
        return new OlapHVaRFunction();
    }

    @Override
    public void addValue(double value)
    {
        values.add(value);
    }

    @Override
    public boolean isResultEmpty()
    {
        return values.size() <= 1;
    }

    @Override
    public double calculate()
    {
        double vo = values.getDouble(values.size() - 1);
        // convert P0, P1.. in Pi*r, P1-P2...
        for (int i = 0; i < values.size() - 1; i++)
        {
            double ret = values.getDouble(i + 1) / values.getDouble(i);
            values.set(i, vo * ret);
        }

        // remove last value
        values.removeLast();

        //sort
        values.sort(DoubleComparators.NATURAL_COMPARATOR);

        // TODO (dad) check exact cut position
        int cutPosition = (int) ((values.size() - 1) * 0.05);

        return values.getDouble(cutPosition);
    }
}