/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.IGFStrToFunctionCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;

public class OlapValidateMemberFunction extends OlapMdxNavigationFunction
{
    public static final String NAME = "ValidateMember";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapValidateMemberFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        try
        {
            return unsafeEvalForCluster(context, args);
        }
        catch (Exception ex)
        {
            // e.g., the member does not exist => generate an error
            OlapLoggers.MDX_EVALUATION.info("[mdx] validateMember : exception", ex);
            return marker(context);
        }
    }

    // -----------------------------------------------------------------------------------------------------------------
    // Do not forget to use at the beginning of the select :
    //
    //                    //#prop( icCube.setDimensionalityCheck = false )
    //
    // -----------------------------------------------------------------------------------------------------------------

    private OlapNonScalarEntity unsafeEvalForCluster(GFContext context, GFFunctionArgs args)
    {
        final int count = args.getArgLength();

        if (count == 1 /* unique-name */)
        {
            final String expr = args.toMdxStringExpression(context, 0);

            if (expr.trim().isEmpty())
            {
                OlapLoggers.MDX_EVALUATION.info("[mdx] validateMember : empty expression");
                return marker(context);
            }

            OlapLoggers.MDX_EVALUATION.info("[mdx] validateMember : validating [" + expr + "]");

            return args.executeStrToMdxExpression(
                    context, true, this, 0, expr, "validate-member-?", new IGFStrToFunctionCallback<>()
                    {
                        @Override
                        public OlapNonScalarEntity onEntityNull()
                        {
                            OlapLoggers.MDX_EVALUATION.info("[mdx] validateMember : null entity");
                            return marker(context);
                        }

                        @Override
                        public OlapNonScalarEntity onEntity(GFContext context1, GFTupleEvaluator evaluator, GFContext constrainedContext, OlapEntity entity1)
                        {
                            if (entity1.isToMemberApplicable(context1.getPrepareContext()))
                            {
                                final OlapMember member = entity1.toNullableMember(constrainedContext.getPrepareContext());

                                if (member == null)
                                {
                                    OlapLoggers.MDX_EVALUATION.info("[mdx] validateMember : null member [" + entity1.getFriendlyTypeName() + "] [" + entity1 + "]");
                                    return marker(context1);
                                }

                                return member;
                            }

                            OlapLoggers.MDX_EVALUATION.info("[mdx] validateMember : not a member [" + entity1.getFriendlyTypeName() + "] [" + entity1 + "]");
                            return marker(context1);
                        }
                    }
            );
        }
        else if (count == 2 /* migrating from old filters : hierarchy-level (?) + name */)
        {
            // [#1997] focus first w/ the filter panel : other filter using names can be migrated later.
        }

        OlapLoggers.MDX_EVALUATION.info("[mdx] validateMember : unexpected arg. count [" + count + "]");
        return marker(context);
    }

    private OlapMember marker(GFContext context)
    {
        final OlapSchema schema = context.getSchema();
        return schema.getOrCreateValidateMemberMarker();
    }

}