/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorOperator;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;

public class OlapSumOnFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "SumOn";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapSumOnFunction()
    {
        this(NAME, ARGS);
    }

    public OlapSumOnFunction(String name, OlapFunctionArgs args)
    {
        super(name, args);
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException
    {
        // [non-empty-behavior] covered: if one of the two is empty the result will be empty
        return S_NonEmptyBehaviorOperator.multiply(context, args[0], args[1]);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapDoubleVectorEntity vector1 = args.asVector(context, 0);
        final OlapDoubleVectorEntity vector2 = args.asVector(context, 1);

        if (vector1 == null || vector2 == null)
        {
            return asEmpty();
        }
        else
        {
            return vector1.sumOn(vector2);
        }
    }
}