/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.IGFStrToFunctionCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.mdx.common.OlapNonScalarStrToFunction;

public class OlapStrToLevelFunction extends OlapNonScalarStrToFunction
{
    public static final String NAME = "StrToLevel";

    public OlapStrToLevelFunction()
    {
        super(NAME);
    }

    @Override
    protected String getTargetTypeName()
    {
        return OlapLevel.FRIENDLY_NAME;
    }

    @Override
    protected IGFStrToFunctionCallback<OlapNonScalarEntity> createStrToCallback(GFFunctionArgs args, int argNb)
    {
        return new IGFStrToFunctionCallback<OlapNonScalarEntity>()
        {
            @Override
            public OlapNonScalarEntity onEntityNull()
            {
                return asNull();
            }

            @Override
            public OlapNonScalarEntity onEntity(GFContext context, GFTupleEvaluator evaluator, GFContext constrainedContext, OlapEntity entity)
            {
                if (entity instanceof OlapLevel)
                {
                    return (OlapLevel) entity;
                }

                return onStrToFunctionConversionError(context, args, argNb, entity);
            }
        };
    }
}
