/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;

import java.util.Arrays;
import java.util.List;

public class OlapReplicateFunction extends OlapNonScalarEntityFunction
{
    public static final String NAME = "Replicate";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                case 1:
                    return OlapFunctionArgumentType.VALUE;
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapReplicateFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final int times = args.toInteger(context, 1);
        if (times <= 0)
        {
            return OlapSetFactory.empty();
        }

        final OlapMember member = args.toMemberIfApplicable(context, 0);
        if (member != null)
        {
            if (member.isMdxNull())
            {
                return OlapSetFactory.empty();
            }
            OlapMember[] members = new OlapMember[times];
            Arrays.fill(members, member);
            return OlapSetFactory.instance(members);
        }
        else
        {
            final OlapTupleSet<OlapMember> memberSet = args.toMemberSet(context, 0, true);
            if (memberSet == null || memberSet.isMdxNull())
            {
                return OlapSetFactory.empty();
            }
            final List<OlapMember> memberList = memberSet.asTupleList().getTuples();
            final int listSize = memberList.size();
            if (listSize == 0)
            {
                return OlapSetFactory.empty();
            }
            OlapMember[] members = new OlapMember[times * listSize];
            for (int j = 0; j < times; j++)
            {
                for (int i = 0; i < listSize; i++)
                {
                    members[j * listSize + i] = memberList.get(i);
                }
            }

            return OlapSetFactory.instance(members);
        }
    }
}
