/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;

public class OlapRemoveUnknownFunction extends OlapNonScalarEntityFunction
{
    public static final String NAME = "RemoveUnknown";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapRemoveUnknownFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "set");

        if (arg0.isMdxNull())
        {
            return OlapSetFactory.empty();
        }

        final OlapTupleSet<? extends OlapTuple> tupleSet = args.toSet(context, 0);

        return OlapSetFactory.instance(

                OlapIteratorFactory.filter(

                        tupleSet.getIterator(false),

                        new OlapAbstractIteratorFilter<OlapTuple>()
                        {
                            @Override
                            public IOlapIteratorFilter<OlapTuple> newInstance()
                            {
                                return this;
                            }

                            @Override
                            public boolean accept(OlapTuple tuple)
                            {
                                for (int i = 0; i < tuple.getMemberCount(); i++)
                                {
                                    final OlapMember member = tuple.getMember(i);

                                    if (member.isCreatedUnknownMember())
                                    {
                                        return false;
                                    }
                                }
                                return true;
                            }
                        }
                )
        );
    }

}