/*
 * Copyright 1999 - 2015 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.math.CdMatrixFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;

public class OlapMatrixNFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "MatrixN";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, Integer.MAX_VALUE)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapMatrixNFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final double[][] values = new double[args.size()][];

        if (args.size() == 0)
        {
            return asEmpty();
        }

        for (int col = 0; col < args.size(); col++)
        {
            OlapDoubleVectorEntity vector = args.toVector(context, col);
            final double[] value = vector.asValue();
            values[col] = value;

            if (col != 0)
            {
                if (values[0].length != value.length)
                {
                    return this.onFunctionError(args.getErrorContext(context), OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, col, "Vector(" + vector.length() + ")", "Vector(" + values[0].length + ")", "");
                }
            }
        }

        if (values[0].length == 0)
        {
            return asEmpty();
        }

        return new OlapDoubleMatrixEntity(CdMatrixFactory.fromVectors(values));
    }

}