/*
 * Copyright 1999 - 2015 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.math.CdIMatrix;
import crazydev.common.math.CdMatrixFactory;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixAEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseGenericMatrixFunction;

public class OlapMatrixAFunction extends OlapBaseGenericMatrixFunction
{
    public static final String NAME = "MatrixA";

    public OlapMatrixAFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapSetCalculatorExpression createCalculator()
    {

        return new OlapSetCalculatorExpression()
        {
            private GFFunctionArgs funArgs;

            public OlapListTupleSet<?> rowList;

            public OlapListTupleSet<?> colList;

            int colSize;

            CdIMatrix values;

            int row = 0;

            int col = 0;

            @Override
            public void init(GFFunctionArgs funArgs, OlapListTupleSet<? extends OlapTuple> rowList, OlapListTupleSet<? extends OlapTuple> colList)
            {
                this.funArgs = funArgs;
                this.rowList = rowList;
                this.colList = colList;
                this.colSize = colList.size();
                values = CdMatrixFactory.create(rowList.size(), colSize);
            }

            @Override
            public void addValue(GFContext context, OlapScalarEntity value)
            {
                if (value instanceof OlapNumericEntity)
                {
                    OlapNumericEntity numeric = (OlapNumericEntity) value;
                    setValue(numeric.doubleValue());
                }
                else
                {
                    funArgs.onFunctionArgTypeMismatchError(context, 3, "numeric", /* !arg */ value.getFriendlyTypeName());

                }
            }

            @Override
            public void addNull()
            {
                setValue(0.0);
            }

            private void setValue(double value)
            {
                values.setValue(row, col, value);
                col++;
                if (col >= colSize)
                {
                    col = 0;
                    row++;
                }
            }

            @Override
            public OlapEntity calculate()
            {
                return new OlapDoubleMatrixAEntity(colList, rowList, values);
            }
        };
    }
}