/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;

abstract class OlapIsLevelTypeFunction extends OlapScalarEntityFunction
{
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapIsLevelTypeFunction(String name)
    {
        super(name, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapEntity arg = args.getNonMissingArgEntity(context, 0, "level|member");
        OlapLevel level = null;
        if (arg.isToMemberApplicable(context))
        {
            final OlapMember member = args.toMember(context, 0);
            level = member == null ? null : member.getLevel();
        }

        if (level == null)
        {
            level = args.toLevel(context, 0);
        }

        boolean res = level != null && level.getLevelType() == getExpectedLevelType();
        return asBoolean(res);
    }

    protected abstract OlapLevelType getExpectedLevelType();
}
