/*
 * Copyright 2014 - 2022 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapIntrinsicMemberPropertyCallInstr;
import crazydev.iccube.olap.eval.function.mdx.string.OlapPropertiesFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.literal.OlapStringLiteralInstr;
import crazydev.iccube.olap.eval.option.OlapOptionInstr;
import org.jetbrains.annotations.Nullable;

public class OlapGetPropertyFunction extends OlapPropertiesFunction
{
    public static final String NAME = "GetProperty";

    protected OlapGetPropertyFunction(String name)
    {
        super(name, ARGS);
    }

    public OlapGetPropertyFunction()
    {
        super(NAME, ARGS);
    }

    @Nullable
    @Override
    public OlapTupleDimensionality getTupleDimensionality(GFNode[] args)
    {
        return getTupleDimensionality(args, 0);
    }

    @Override
    @Nullable
    public OlapInstr asInstr(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, OlapInstr[] args)
    {
        if (args.length >= 2 && args[1] instanceof OlapStringLiteralInstr)
        {
            final String propName = ((OlapStringLiteralInstr) args[1]).getValue().value();

            final OlapIntrinsicMemberProperty property = context.getIntrinsicProperty(propName);

            if (property != null && (property.isTyped() || isTyped(args)))
            {
                return new OlapIntrinsicMemberPropertyCallInstr(location, property, args[0]);
            }
        }

        return super.asInstr(context, location, mdxNotation, args);
    }

    private boolean isTyped(OlapInstr[] args)
    {
        if (args.length == 3 && args[2] instanceof OlapOptionInstr)
        {
            final OlapOptionInstr o = (OlapOptionInstr) args[2];
            return o.getOption() == OlapOption.TYPED;
        }

        return false;
    }

    protected boolean isNullable()
    {
        return true;
    }
}