/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;

public class OlapGetMonitoringCounterFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "GetMonitoringCounter";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapGetMonitoringCounterFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final IOlapBigBrotherMgr bigBrother = args.getBigBrother(context);

        if (bigBrother == null)
        {
            throw new OlapEvaluationException(args.getErrorContext(context), OlapErrorCode.MISSING_MONITORING_BIGBROTHER);
        }

        final String beanName = args.toString(context, 0);
        final Double value = bigBrother.getMonitoringCounterValue(beanName);

        return value == null ? asEmpty() : new OlapNumericEntity(value);
    }

}