/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.eval.execinstr.OlapDivNFunctionCallPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapDivNFunction extends OlapBaseNFunction
{
    public static final String NAME = "DivN";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return OlapFunctionArgumentType.VALUE;
            }
        }
    };

    public OlapDivNFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs)
    {
        return new OlapDivNFunctionCallPreparedInstr(callInstr, args, this, pArgs);
    }

}
