/*
 * Copyright 2014 - 2022 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.util.IOlapExistCalculator;
import crazydev.iccube.olap.util.OlapExistCalculator;

import java.util.function.BiPredicate;

public class OlapDSColumnValueFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "dsColumnValue";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2);

    public OlapDSColumnValueFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapMember member = args.toMember(context, 0, true);
        final OlapHierarchy hierarchy = args.toHierarchy(context, 1, true);
        final OlapMemberFilter memberFilter = context.getMemberFilter();
        final OlapTupleFilter tupleFilter = context.getMemberTupleFilter();

        if (member == null || hierarchy == null)
        {
            return asEmpty();
        }

        // we are doing a kind of crossjoir, so need to apply security and autoexist manually
        final OlapTupleDimensionality dimensionality = member.getTupleDimensionality().or(hierarchy.getTupleDimensionality());
        final BiPredicate<OlapMember, OlapMember> tupleExists = (member1, member2) -> {
            if (tupleFilter == null)
            {
                return true;
            }

            final OlapTuple tuple = OlapTupleFactory.instance(dimensionality, member, member2);
            return tupleFilter.isAccepting(tuple);
        };

        if (member.getHierarchy().hasOneRelationWithBase(hierarchy))
        {
            // easy one it's an attribute
            final OlapMember attributeMember = member.getAttributeMember(hierarchy);
            if (attributeMember == null || (memberFilter != null && !memberFilter.isAccepting(member)))
            {
                return asEmpty();
            }
            if (!tupleExists.test(member, attributeMember))
            {
                return asEmpty();
            }

            final String caption = getCaption(context, attributeMember);
            return new OlapStringEntity<>(caption);
        }
        else
        {
            // crossjoin between member and all members of the last level of the hierarchy
            final OlapLevel lastLevel = hierarchy.getLastLevel();
            final OlapIterator<OlapMember> iter = lastLevel.getMembers(memberFilter).getIterator(false);

            IOlapExistCalculator calculator = null;
            StringBuilder captionsAsString = new StringBuilder();
            OlapMember levelMember;
            iter.reset();
            while ((levelMember = iter.next()) != null)
            {
                calculator = calculator == null ? OlapExistCalculator.create(member, levelMember) : calculator;
                if (calculator.exists(member, levelMember) && tupleExists.test(member, levelMember))
                {
                    captionsAsString.append(captionsAsString.length() == 0 ? "" : ", ");
                    captionsAsString.append(getCaption(context, levelMember));
                }
            }

            // join existing members
            if (captionsAsString.length() == 0)
            {
                return asEmpty();
            }
            return new OlapStringEntity<>(captionsAsString.toString());
        }

    }

    private static String getCaption(GFContext context, OlapMember levelMember)
    {
        return levelMember.getCaption(context.getLocale(), context.getNameContext());
    }
}