/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;

/**
 * Handy in CELL PROPERTIES expression evaluation.
 */
public class OlapCurrentCellValueFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "CurrentCellValue";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapCurrentCellValueFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapEvalResultCellValue value = args.getCellValue(context);

        final OlapException error = value.getError();

        if (error == null)
        {
            final OlapScalarEntity scalar = value.getScalarValue();

            if (scalar == null /* should not be the case anymore */)
            {
                return OlapEmptyEntity.INSTANCE;
            }

            return scalar.asConstant() /* must never change its value when used in math expression */;
        }

        // A cell evaluation has generated an error.

        // Remember that currentCellValue() is used during CELL PROPERTIES evaluation
        // (I mean the only way to get a CELL value I guess). Currently, when a cell
        // is on error those CELL PROPERTIES are not evaluated therefore we should
        // not be here ...

        throw error; // for consistent usage of isError() function ...
    }

}