/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.function.OlapEntityFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Guess for Reporting v7.x (=> not documented).
 */
public class OlapCombineFunction extends OlapEntityFunction
{
    public static final String NAME = "Combine";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0, OlapFunctionArgs.N)
    {
        @Override
        public boolean isLambda(int pos)
        {
            return pos >= 1;
        }

    };

    public OlapCombineFunction()
    {
        super(NAME, ARGS);
    }

    @Nullable
    @Override
    public OlapTupleDimensionality getTupleDimensionality(GFNode[] args)
    {
        final List<OlapTupleDimensionality> dimensionalities = Arrays.stream(args).map(GFNode::getTupleDimensionality).collect(Collectors.toList());
        return OlapTupleDimensionalityFactory.createUnionEx(dimensionalities);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs)
    {
        return super.doPrepareFunctionCall(context, callInstr, args, pArgs);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        int argNumber = args.getArgLength();
        if (argNumber == 0)
        {
            return OlapSetFactory.empty();
        }
        if (argNumber == 1)
        {
            return args.toSet(context, 0);
        }

        // materialize all sets and check if it's the same hierarchy with a single member
        OlapTupleDimensionality dimSet = null;
        ArrayList<OlapTupleSet<? extends OlapTuple>> setOfSets = new ArrayList<>();
        boolean sameHierarchy = true;
        for (int i = 0; i < argNumber; i++)
        {
            final OlapTupleSet<? extends OlapTuple> olapSet = args.toSet(context, i);
            final OlapListTupleSet<? extends OlapTuple> olapList = olapSet == null ? OlapSetFactory.empty() : olapSet.asTupleList();
            final OlapTupleDimensionality setDimensionality = olapList.getTupleDimensionality();
            if (setDimensionality == null || setDimensionality.cardinality() != 1 || (dimSet != null && !dimSet.intersects(setDimensionality)))
            {
                sameHierarchy = false;
            }
            dimSet = setDimensionality;
            setOfSets.add(olapList);
        }

        if (setOfSets.isEmpty())
        {
            return OlapSetFactory.empty();
        }

        if (sameHierarchy)
        {
            return doSameHierarchyMember(setOfSets);
        }
        else
        {
            // maybe an error ?
            return doCrossjoin(context, args, setOfSets);
        }


    }

    private OlapNonScalarEntity doCrossjoin(GFContext context, GFFunctionArgs args, List<OlapTupleSet<?>> setOfSets)
    {
        final OlapIterator<OlapTuple> iterator = OlapIteratorFactory.crossjoin(context, args, true, setOfSets);
        return OlapSetFactory.instance(iterator);
    }

    private OlapNonScalarEntity doSameHierarchyMember(ArrayList<OlapTupleSet<? extends OlapTuple>> setOfSets)
    {
        final List<ArrayList<OlapMember>> listOfMemberList = setOfSets.stream()
                .filter(set -> !set._isEmpty())
                .map(set -> new ArrayList<OlapMember>((Collection<? extends OlapMember>) set.asTupleList().getTuples()))
                .collect(Collectors.toList());

        ArrayList<OlapTuple> outputSet = new ArrayList<>();

        for (int i = 0; i < listOfMemberList.get(0).size(); i++)
        {
            OlapMember member = listOfMemberList.get(0).get(i);
            outputSet.add(member);
            addDescendants(listOfMemberList, outputSet, member, 1);
        }

        // add all members that have not been added yet in the same order as defined
        for (int i = 1; i < listOfMemberList.size(); i++)
        {
            final ArrayList<OlapMember> list = listOfMemberList.get(i);
            for (int j = 0; j < list.size(); j++)
            {
                OlapMember olapMember = list.get(j);
                if (olapMember != null)
                {
                    outputSet.add(olapMember);
                }
            }
        }

        return OlapSetFactory.instance(outputSet);
    }

    private void addDescendants(List<ArrayList<OlapMember>> setList, ArrayList<OlapTuple> outputSet, OlapMember parentMember, int setIdx)
    {
        if (setIdx >= setList.size())
        {
            return;
        }
        final ArrayList<OlapMember> set = setList.get(setIdx);
        for (int i = 0; i < set.size(); i++)
        {
            final OlapMember member = set.get(i);
            if (member != null && member.isDescendant(parentMember))
            {
                set.set(i, null); //  we need to add a member only once
                outputSet.add(member);
                addDescendants(setList, outputSet, member, setIdx + 1);
            }
        }
    }


}