/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.plugin.olapfunctions.others.instr.OlapCoalesceNullFunctionCallPreparedInstr;

public class OlapCoalesceNullFunction extends OlapNonScalarEntityFunction
{
    public static final String NAME = "CoalesceNull";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, OlapFunctionArgs.N);

    public OlapCoalesceNullFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs)
    {
        return new OlapCoalesceNullFunctionCallPreparedInstr(callInstr, args, this, pArgs);
    }

}