/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.facts.aggregation.table.OlapTableAggregatorRepository;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;

public class OlapAddTableAggregrationFunction extends OlapMdxNavigationFunction
{
    public static final String NAME = "AddTableAggregation";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                case 1:
                    return OlapFunctionArgumentType.VALUE;
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapAddTableAggregrationFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapMember member = args.toMember(context, 0);
        final String className = args.toString(context, 1);

        if (member instanceof OlapMeasureMember measureMember)
        {
            final OlapEngineComponent engine = context.getRequestContext().getOlapEngineComponent();
            final OlapTableAggregatorRepository repository = engine.getTableAggregationRepository();
            if (CdStringUtils.isNullOrBlank(className))
            {
                measureMember.setTableAggregator(null);
            }
            else
            {
                final IOlapFactTableAggregatorFactory tableAggregator = repository.lookupAggregator(className);
                if (tableAggregator == null)
                {
                    return onFunctionError(context, OlapErrorCode.TABLE_AGGR_MISSING, className);
                }
                measureMember.setTableAggregator(tableAggregator);
            }
        }

        return member;
    }


}