/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.excel;

import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import crazydev.iccube.plugin.function.OlapPluginUserJavaFunction;

@SuppressWarnings({"UnusedDeclaration"})
public class OlapVBExcelMiscFunctions
{
    public static abstract class OneArg extends OlapPluginUserJavaFunction
    {
        protected OneArg()
        {
            super(1, Object.class);
        }

        @Override
        public final Object doEval(Object[] args) throws OlapPluginEvaluationException
        {
            return evaluate(args[0]);
        }

        protected abstract Object evaluate(Object obj);
    }

    public static final OlapPluginUserJavaFunction STR = new OneArg()
    {
        @Override
        protected Object evaluate(Object d)
        {
            if (d == null)
            {
                return 0  /* SSAS */;
            }
            return String.valueOf(d);
        }
    };

}
