/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.searchconsole.datasource;

import com.google.api.services.searchconsole.v1.model.SearchAnalyticsQueryRequest;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.xml.CdLocalDateXmlAdapter;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.googleapi.OlapBuilderGoogleCommon;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static crazydev.iccube.builder.googleapi.OlapBuilderGoogleCommon.format;

@XmlRootElement(name = "GSCDataTable")
@XmlAccessorType(XmlAccessType.FIELD)
public class OlapBuilderGoogleSearchConsole4DataTable extends OlapBuilderBaseDataTable<OlapBuilderGoogleSearchConsoleConnection>
{
    public static final CdProperty START_DATE = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataTable.class, "startDate", false);

    public static final CdProperty END_DATE = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataTable.class, "endDate", false);

    public static final CdProperty DIMENSIONS = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataTable.class, "dimensions");

    public static final CdProperty MAX_DAYS_FOR_SINGLE_QUERY = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataTable.class, "maxDaysForSingleQuery", false);

    public static final String END_LOAD_DATE_COL_NAME = "icEndLoadDate";

    @XmlAttribute(required = true)
    protected String dimensions = "query,page,country,device,date"; // searchAppearance

    @XmlAttribute(required = false)
    private Integer maxDaysForSingleQuery;

    @Nullable
    @XmlJavaTypeAdapter(value = CdLocalDateXmlAdapter.class)
    @XmlAttribute(required = false)
    private LocalDate startDate;

    @Nullable
    @XmlJavaTypeAdapter(value = CdLocalDateXmlAdapter.class)
    @XmlAttribute(required = false)
    private LocalDate endDate;

    protected OlapBuilderGoogleSearchConsole4DataTable()
    {
    }

    protected OlapBuilderGoogleSearchConsole4DataTable(String tableName)
    {
        super(tableName);
    }

    OlapBuilderGoogleSearchConsole4DataSource getTypedDS()
    {
        return (OlapBuilderGoogleSearchConsole4DataSource) getDataSource();
    }

    @Override
    public boolean isNameReadOnly()
    {
        return false;
    }

    @Override
    public String getInternalFriendlyTypeName()
    {
        return "GA4 Table";
    }

    @Override
    public boolean isDiscoveredInDataSource()
    {
        return false;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderGoogleSearchConsoleConnection connection, OlapBuilderErrorManager errorManager)
    {
        return doDiscoverAllColumnsForRefresh(context, connection, errorManager);
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderGoogleSearchConsoleConnection connection, OlapBuilderErrorManager errorManager)
    {
        // =========================================================================================================
        // I'm returning all the current columns => the table won't be changed.
        // Remember : return a new list (the caller is assuming a #discover() )
        // =========================================================================================================

        final List<IOlapBuilderDataColumnDef> fake = new ArrayList<IOlapBuilderDataColumnDef>();
        if (dimensions != null)
        {
            Arrays.stream(dimensions.split(",")).map(String::trim).forEach(s -> {
                fake.add(new OlapBuilderDataColumn(s.equals("date") ? OlapBuilderInputType.DATE : OlapBuilderInputType.STRING, OlapBuilderGoogleCommon.DIMENSION_PREFIX, OlapBuilderGoogleCommon.DIMENSION_PREFIX + s));
            });
        }
        fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, OlapBuilderGoogleCommon.METRIC_PREFIX, OlapBuilderGoogleCommon.METRIC_PREFIX + "CLICKS"));
        fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, OlapBuilderGoogleCommon.METRIC_PREFIX, OlapBuilderGoogleCommon.METRIC_PREFIX + "POSITIONS"));
        fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, OlapBuilderGoogleCommon.METRIC_PREFIX, OlapBuilderGoogleCommon.METRIC_PREFIX + "CTR"));
        fake.add(new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, OlapBuilderGoogleCommon.METRIC_PREFIX, OlapBuilderGoogleCommon.METRIC_PREFIX + "IMPRESSIONS"));

        // map actual names for the UI to the name of the column and the type to the api name
        return fake;
    }

    @Nullable SearchAnalyticsQueryRequest buildRequest(LocalDate startDate)
    {
        LocalDate endDate = getTypedDS().getEndDate();
        endDate = endDate == null ? new LocalDate() : endDate;
        if (startDate.isAfter(endDate))
        {
            return null;
        }
        if (maxDaysForSingleQuery != null)
        {
            final LocalDate maxEndDate = startDate.plusDays(maxDaysForSingleQuery - 1);
            if (maxEndDate.isBefore(endDate))
            {
                endDate = maxEndDate;
            }
        }
        final List<String> dimensions = Arrays.stream(this.dimensions.split(",")).map(String::trim).toList();
        SearchAnalyticsQueryRequest request = new SearchAnalyticsQueryRequest().setStartDate(startDate.toString(format)).setEndDate(endDate.toString(format)).setDimensions(dimensions).setRowLimit(getTypedDS().getRowLimit());

        return request;
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderGoogleSearchConsoleConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount)
    {
        return new OlapBuilderGoogleSearchConsole4RowReader(context, connectionPool, maxRowCount, this);
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable)
    {
        if (super.isRefreshColumnOnUpdate(newTable))
        {
            return true;
        }

        final OlapBuilderGoogleSearchConsole4DataTable tableUpdate = (OlapBuilderGoogleSearchConsole4DataTable) newTable;

        return !Objects.equals(this.dimensions, tableUpdate.dimensions);
    }

}
