/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.searchconsole.datasource;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.xml.CdLocalDateXmlAdapter;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

import java.io.File;
import java.util.Arrays;
import java.util.List;

/**
 * Datasource implementation for the <b>Excel</b> files.
 */
@XmlRootElement(name = "GSCDataSource")
public class OlapBuilderGoogleSearchConsole4DataSource extends OlapBuilderBaseDataSource<OlapBuilderGoogleSearchConsoleConnection>
{
    public static final CdProperty DOMAIN = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataSource.class, "domain", true);

    public static final CdProperty START_DATE = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataSource.class, "startDate", false);

    public static final CdProperty END_DATE = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataSource.class, "endDate", false);

    public static final CdProperty SERVICE_ACCOUNT_PRIVATE_KEY = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataSource.class, "serviceAccountPrivateKey", false)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return File.class;
        }

    };

    public static final CdProperty ROW_LIMIT = new CdReadWriteProperty(OlapBuilderGoogleSearchConsole4DataSource.class, "rowLimit", false);

    final static List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(OlapBuilderGoogleSearchConsole4DataTable.class);

    @XmlAttribute(required = true)
    protected String domain;

    @Nullable
    @XmlJavaTypeAdapter(value = CdLocalDateXmlAdapter.class)
    @XmlAttribute(required = false)
    private LocalDate startDate;

    @Nullable
    @XmlJavaTypeAdapter(value = CdLocalDateXmlAdapter.class)
    @XmlAttribute(required = false)
    private LocalDate endDate;

    @XmlAttribute(required = true)
    private String propertyId;

    @XmlAttribute(required = true)
    private String serviceAccountPrivateKey;

    @XmlAttribute(required = false)
    private Integer rowLimit;

    public OlapBuilderGoogleSearchConsole4DataSource()
    {
        super();
    }

    @Override
    protected String getReportDataSourceType()
    {
        return "googleSearchConsole v4";
    }

    @Override
    protected String getReportDataSourceTypeCaption()
    {
        return "Google Search Console v4";
    }

    @Override
    public boolean isDiscoverTablesSupported()
    {
        return false;
    }

    /**
     * @return a possibly null list of table that can be created by this datasource.
     */
    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes()
    {
        return CREATED_TABLE_TYPES;
    }

    @Override
    public OlapBuilderGoogleSearchConsoleConnection createConnection(OlapRuntimeContext context, boolean forceRefresh)
    {
        return new OlapBuilderGoogleSearchConsoleConnection(this);
    }

    @Override
    public OlapBuilderGoogleSearchConsole4DataTable createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType)
    {
        return new OlapBuilderGoogleSearchConsole4DataTable();
    }

    @Override
    public UxBuilderDataSourceTypeGroupId getUxGroupId()
    {
        return UxBuilderDataSourceTypeGroupId.dsTypeGroupGoogle;
    }

    public String getServiceAccountPrivateKey()
    {
        return serviceAccountPrivateKey;
    }

    @Nullable
    public LocalDate getStartDate()
    {
        return startDate;
    }

    public String getDomain()
    {
        return domain;
    }

    @Nullable
    public LocalDate getEndDate()
    {
        return endDate;
    }

    public int getRowLimit()
    {
        return rowLimit == null ? 25000 : rowLimit;
    }
}
