/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.ga4.datasource;

import com.google.analytics.data.v1beta.BetaAnalyticsDataClient;
import com.google.analytics.data.v1beta.BetaAnalyticsDataSettings;
import com.google.auth.oauth2.ServiceAccountCredentials;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class OlapBuilderGoogleAnalytics4Connection extends OlapBuilderAbstractConnection<OlapBuilderGoogleAnalytics4DataSource>
{
    private BetaAnalyticsDataClient dataClient;

    public OlapBuilderGoogleAnalytics4Connection(OlapBuilderGoogleAnalytics4DataSource dataSource)
    {
        super(dataSource);
    }

    @Override
    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException
    {
        // do not call createDataClient() , one use only
    }

    private synchronized BetaAnalyticsDataClient createDataClient(OlapRuntimeContext context)
    {
        if (dataClient != null)
        {
            return dataClient;
        }
        final String serviceAccountKeyFile = dataSource.getServiceAccountPrivateKey();
        final File trusted = context.getUserDefinedFile(serviceAccountKeyFile);

        try
        {
            final ServiceAccountCredentials service = ServiceAccountCredentials.fromStream(new FileInputStream(trusted));
            dataClient = BetaAnalyticsDataClient.create(
                    BetaAnalyticsDataSettings.newBuilder()
                            .setCredentialsProvider(() -> service)
                            .build());
            return dataClient;
        }
        catch (IOException e)
        {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, e);
        }
    }

    @Override
    protected void onClose()
    {
        if (dataClient != null)
        {
            try
            {
                dataClient.close();
            }
            catch (Exception e)
            {
                OlapLoggers.BUILDER.warn("onClose() error", e);
            }
        }
    }

    public BetaAnalyticsDataClient getAnalyticsData(OlapRuntimeContext context)
    {
        return createDataClient(context);
    }
}
