/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTable;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;

public class OlapBuilderGoogleSpreadsheetDataTableRowReader
        extends OlapBuilderAbstractTableRowReader<OlapBuilderGoogleSpreadsheetDataTable, OlapBuilderGoogleSpreadsheetConnection>
{
    private OlapBuilderExcelDataTableRowReader excelRowReader;

    public OlapBuilderGoogleSpreadsheetDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderGoogleSpreadsheetDataTable table)
    {
        super(context, connectionPool, maxRowCount, table, table.getName());
    }

    @Override
    public void doInit()
    {
        initConnection();

        final OlapBuilderExcelDataTable sheetTable = table.buildTable();

        excelRowReader = sheetTable.createFullTableRowReaderForGoogle(context, connectionPool, maxRowCount, connection.getExcelConn());
        excelRowReader.doInit();
    }

    @Override
    public boolean isRowSafe()
    {
        return excelRowReader.isRowSafe();
    }

    @Override
    public IOlapBuilderTableRow doNextRow()
    {
        return excelRowReader.doNextRow();
    }

    /**
     * Will be called as soon as the init method has been called (either successfully or on error).
     * Keep it safe as it is typically called from a finally block.
     */
    @Override
    public void done()
    {
        if (excelRowReader != null)
        {
            excelRowReader.done();
        }

        super.done();
    }

}
