/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiDataSource;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleDataSourceUxWizard;
import crazydev.iccube.builder.googleapi.common.OlapBuilderWizardWebTokenUxModel;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import org.jetbrains.annotations.NotNull;

class OlapBuilderGoogleSpreadsheetDataSourceUxWizard extends OlapBuilderGoogleDataSourceUxWizard<OlapBuilderGoogleSpreadsheetDataSource, OlapBuilderGoogleDriveUxModel, OlapBuilderWizardWebTokenUxModel>
{
    OlapBuilderGoogleSpreadsheetDataSourceUxWizard(OlapBuilderGoogleSpreadsheetDataSource ds, String dataSourceTypeId)
    {
        super(dataSourceTypeId, createUxCreateWizardSteps(), ds);
    }

    @NotNull
    @Override
    protected OlapBuilderGoogleDriveUxModel createWebTokenModel()
    {
        return new OlapBuilderGoogleDriveUxModel();
    }

    @Override
    protected @NotNull Object createScopeModelForService()
    {
        return new OlapBuilderGoogleSpreadsheetUxModel();
    }

    @Override
    public OlapBuilderGoogleApiDataSource getDataSourceFromUIForWebtoken()
    {
        final OlapBuilderGoogleDriveUxModel websiteModel = getStepModelFor(OlapBuilderGoogleDriveUxModel.class);

        final OlapBuilderGoogleSpreadsheetDataSource dataSource = new OlapBuilderGoogleSpreadsheetDataSource();
        dataSource.setTokenSubscope(websiteModel.getTokenSubscope());
        return dataSource;
    }

    @Override
    protected OlapBuilderGoogleApiDataSource getDataSourceFromUIForServiceAccount()
    {
        final OlapBuilderGoogleSpreadsheetUxModel model = getStepModelFor(OlapBuilderGoogleSpreadsheetUxModel.class);

        final OlapBuilderGoogleSpreadsheetDataSource dataSource = new OlapBuilderGoogleSpreadsheetDataSource();
        dataSource.setFileName(model.getFileName());
        dataSource.setFileId(model.getFileId());
        return dataSource;
    }

    @Override
    public IOlapBuilderDataSource getDataSourceFromUI()
    {
        final OlapBuilderGoogleSpreadsheetDataSource ds = (OlapBuilderGoogleSpreadsheetDataSource) super.getDataSourceFromUI();
        final OlapBuilderGoogleSpreadsheetUxModel model = getStepModelFor(OlapBuilderGoogleSpreadsheetUxModel.class);

        ds.setFileName(model.getFileName());
        ds.setFileId(model.getFileId());

        return ds;
    }
}
