/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiDataSource;
import jakarta.xml.bind.annotation.XmlAttribute;

public abstract class OlapBuilderGoogleDriveDataSource<CON extends OlapBuilderGoogleDriveConnection> extends OlapBuilderGoogleApiDataSource<CON>
{
    public static final CdProperty TOKEN_SUBSCOPE = new CdReadWriteProperty(OlapBuilderGoogleDriveDataSource.class, "tokenSubscope", false);

    @XmlAttribute(required = false)
    private String tokenSubscope;

    public OlapBuilderGoogleDriveDataSource()
    {
    }

    public OlapBuilderGoogleDriveDataSource(String serviceAccountPrivateKey)
    {
        super(serviceAccountPrivateKey);
    }

    public String getTokenSubscope()
    {
        return tokenSubscope;
    }

    public void setTokenSubscope(String tokenSubscope)
    {
        this.tokenSubscope = tokenSubscope;
    }
}
