/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */

import crazydev.common.utils.CdLog4jUtils;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.sql.*;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SimbaShell
{
    public static void main(String[] args)
    {
        CdLog4jUtils.configure(org.apache.logging.log4j.Level.DEBUG);
        {
            Logger.getLogger("io.grpc").setLevel(Level.INFO);
        }

        final GcInfoLogger gc = new GcInfoLogger(200);
        gc.start();

        final long procStartMS = System.currentTimeMillis();

        final AtomicInteger rowNB = new AtomicInteger();

        rowNB.addAndGet(safeMainPeople(null));

//        final CountDownLatch sync = new CountDownLatch(2);
//
//        new Thread(() -> {
//            rowNB.addAndGet(safeMainPeople(true));
//            sync.countDown();
//        }).start();
//
//        new Thread(() -> {
//            rowNB.addAndGet(safeMainPeople(false));
//            sync.countDown();
//        }).start();
//
//        sync.await();

        final long procEndMS = System.currentTimeMillis();

        OlapLoggers.GENERAL.info("request completed : " + rowNB.get() + " " + (int) ((procEndMS - procStartMS) / 1000.0) + "s");

        gc.stop();
    }

    public static int safeMainPeople(Boolean male)
    {

        try
        {

            return mainPeople(male);

        }
        catch (SQLException ex)
        {
            ex.printStackTrace();
            return 0;
        }
    }

    public static int mainPeople(Boolean male) throws SQLException
    {
        // jdbc:bigquery://https://www.googleapis.com/bigquery/v2:443;ProjectId=iccube.com:iccube-main;OAuthType=0;OAuthServiceAcctEmail=unit-testing@iccube-main.iccube.com.iam.gserviceaccount.com;OAuthPvtKeyPath=D:/icCube/examples/ga/voila.json;EnableHighThroughputAPI=1;AllowLargeResults=0;LogLevel=4

        OlapLoggers.GENERAL.info("started.1");

        final Connection connection = DriverManager.getConnection(
                "jdbc:bigquery://https://www.googleapis.com/bigquery/v2:443;" +
                "ProjectId=iccube.com:iccube-main;" +
                "OAuthType=0;" +
                "OAuthServiceAcctEmail=unit-testing@iccube-main.iccube.com.iam.gserviceaccount.com;" +
                // "OAuthPvtKeyPath=D:/icCube/examples/ga/voila.json;" +
                "OAuthPvtKeyPath=/home/mpo/icCube/google-api/voila.json;" +
                "EnableHighThroughputAPI=1;" +
                "AllowLargeResults=0;" +
                "LogLevel=4;"
        );

        // BigQuery Storage API : https://cloud.google.com/bigquery/docs/reference/storage/

        // connection.setAutoCommit(false);
        connection.setReadOnly(true);

        final String sql = "select * from Test.natality_group_by" + ((male != null) ? (" where is_male = " + male) : "");

        OlapLoggers.GENERAL.info("started.2");

        final PreparedStatement statement = connection.prepareStatement(
                sql,
                ResultSet.TYPE_FORWARD_ONLY,
                ResultSet.CONCUR_READ_ONLY
        );

        statement.setFetchSize(1000);

        final long procStartMS = System.currentTimeMillis();

        long startMS = procStartMS;
        OlapLoggers.GENERAL.info("started.3");

        final ResultSet resultSet = statement.executeQuery();

        long endMS = System.currentTimeMillis();

        OlapLoggers.GENERAL.info("query executed : " + (endMS - startMS) + "ms");

        final long procStartMS_ = endMS;

        int rowNB = 0;

        final List<Object[]> rows = new ArrayList<>();

        startMS = endMS;
        while (resultSet.next())
        {
            if (rowNB % 100_000 == 0)
            {
                endMS = System.currentTimeMillis();
                OlapLoggers.GENERAL.info(rowNB + " : " + (endMS - startMS) + "ms : " + CdStringUtils.formatNice((int) (100_000 / (endMS - startMS) * 1000.0)) + "r/s");
                startMS = endMS;
            }

            rowNB++;

            Object year = resultSet.getObject(1);
            Object state = resultSet.getObject(2);
            Object is_male = resultSet.getObject(3);
            Object mother_age = resultSet.getObject(4);
            Object father_age = resultSet.getObject(5);
            Object mother_married = resultSet.getObject(6);
            Object cigarettes_per_day = resultSet.getObject(7);
            Object drinks_per_week = resultSet.getObject(8);
            Object sum_weight_pounds = resultSet.getObject(9);
            Object count_born = resultSet.getObject(10);
            Object female_count = resultSet.getObject(11);
            Object male_count = resultSet.getObject(12);

            rows.add(new Object[]{year, state, is_male, mother_age, father_age, mother_married, cigarettes_per_day, drinks_per_week, sum_weight_pounds, count_born, female_count, male_count});
        }

        resultSet.close();
        statement.close();

        final long procEndMS = System.currentTimeMillis();

        OlapLoggers.GENERAL.info("request completed : " + rowNB + " WITH-QUERY:" + (int) (rowNB / (procEndMS - procStartMS) * 1000.0) + "r/s" + " " + (int) (rowNB / (procEndMS - procStartMS_) * 1000.0) + "r/s");
        OlapLoggers.GENERAL.info("request completed : " + rowNB + " " + (int) ((procEndMS - procStartMS) / 1000.0) + "s");

        return rowNB;
    }

    static class GcInfoLogger
    {
        private final Map<GarbageCollectorMXBean, GcInfo> gcInfos = new IdentityHashMap<GarbageCollectorMXBean, GcInfo>();

        private final Thread thread;

        private volatile boolean requestToStop;

        GcInfoLogger(final int millis)
        {
            this.thread = new Thread(new Runnable()
            {
                @Override
                public void run()
                {
                    while (!requestToStop)
                    {
                        try
                        {
                            Thread.sleep(millis);
                        }
                        catch (InterruptedException ignored)
                        {
                        }

                        try
                        {
                            final List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();

                            // This list is dynamic and might change during JVM execution ...

                            final int size = beans.size();

                            for (int ii = 0; ii < size; ii++)
                            {
                                final GarbageCollectorMXBean bean = beans.get(ii);

                                GcInfo gcInfo = gcInfos.get(bean);

                                if (gcInfo == null)
                                {
                                    gcInfos.put(bean, gcInfo = new GcInfo(bean));
                                }

                                final long updateMS = gcInfo.update();

                                if (updateMS != -1)
                                {
                                    final String max = CdSizeUtils.format(Runtime.getRuntime().maxMemory());
                                    final String total = CdSizeUtils.format(Runtime.getRuntime().totalMemory());
                                    final String free = CdSizeUtils.format(Runtime.getRuntime().freeMemory());

                                    final String info = " ( free:" + free + " / total:" + total + " / max:" + max + " )";

                                    final String name = gcInfo.bean.getName();
                                    final String update = updateMS + "ms";

                                    OlapLoggers.GENERAL.warn("[GC] (" + name + ") : " + update + info);

                                }
                            }
                        }
                        catch (Exception ex /* unlikely */)
                        {
                            OlapLoggers.GENERAL.fatal("[GC] error : ", ex);
                            break;
                        }
                    }
                }
            }, "gc");
        }

        public void start()
        {
            thread.start();
        }

        public void stop()
        {
            requestToStop = true;
            thread.interrupt();
        }
    }

    static class GcInfo
    {
        private final GarbageCollectorMXBean bean;

        private long latestTime;

        public GcInfo(GarbageCollectorMXBean bean)
        {
            this.bean = bean;
            this.latestTime = bean.getCollectionTime();
        }

        public long update()
        {
            final long time = bean.getCollectionTime();

            if (time > latestTime)
            {
                final long update = time - latestTime;
                latestTime = time;
                return update;
            }

            return -1;
        }
    }

}
