/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdSql;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

@XmlRootElement(name = "goBigqueryStatementDT")
public class OlapBuilderGoogleBigqueryStatementDataTable extends OlapBuilderGoogleBigqueryBaseDataTable implements IOlapBuilderJaxbListener
{
    public static final CdProperty STATEMENT = new CdReadWriteProperty(OlapBuilderGoogleBigqueryStatementDataTable.class, "statement", true)
    {
        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdSql.class;
        }
    };

    public static final CdProperty STATEMENT_INCREMENTAL = new CdReadWriteProperty(OlapBuilderGoogleBigqueryStatementDataTable.class, "statementIncremental", false)
    {
        @Override
        public boolean isForIncrLoad()
        {
            return true;
        }

        @Override
        public Class<?> getTypeForDefaultEditor()
        {
            return CdSql.class;
        }
    };

    public static final CdProperty USE_LEGACY_CODE = new CdReadWriteProperty(OlapBuilderGoogleBigqueryStatementDataTable.class, "useLegacyCode", true);

    @XmlAttribute(required = true)
    protected String statement;

    @XmlAttribute(required = false)
    protected String statementIncremental;

    @XmlAttribute()
    protected Boolean useLegacyCode = false;

    public OlapBuilderGoogleBigqueryStatementDataTable()
    {
    }

    public OlapBuilderGoogleBigqueryStatementDataTable(String tableName, String statement)
    {
        super(tableName);
        this.statement = statement;
    }

    @Override
    public boolean isNameReadOnly()
    {
        return false;
    }

    public boolean isDiscoveredInDataSource()
    {
        return false;
    }

    @Override
    public String getInternalFriendlyTypeName()
    {
        return "Google BigQuery Statement";
    }

    protected boolean useLegacyCode()
    {
        return useLegacyCode == null || useLegacyCode || statement.startsWith("#legacySQL");
    }

    @Override
    protected String buildSelect(OlapBuilderGoogleBigqueryConnection connection, @Nullable Comparable incrLoadMarker)
    {
        if (incrLoadMarker != null)
        {
            if (CdStringUtils.isNotNullAndNotBlank(statementIncremental))
            {
                final String restriction = setupIncrLoadRestrictionValue(getName(), incrLoadMarker);

                return statementIncremental.replace("?", restriction);
            }

            final String restriction = setupIncrLoadRestriction(getName(), incrLoadMarker);

            return "SELECT * FROM (" + statement + ") temp WHERE " + restriction;
        }

        return statement;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderGoogleBigqueryConnection>, IOlapBuilderDataTableDef<OlapBuilderGoogleBigqueryConnection>> getValidator()
    {
        return new OlapBuilderBigQueryStatementDataTableValidator();
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable)
    {
        if (super.isRefreshColumnOnUpdate(newTable))
        {
            return true;
        }

        final OlapBuilderGoogleBigqueryStatementDataTable tableUpdate = (OlapBuilderGoogleBigqueryStatementDataTable) newTable;

        return !Objects.equals(this.statement, tableUpdate.statement);
    }

    @Override
    public void beforeMarshal()
    {

    }

    @Override
    public void afterUnmarshal()
    {
        useLegacyCode = useLegacyCode == null || useLegacyCode;
    }
}
