/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.BigqueryScopes;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiConnection;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.request.IcCubeRequest;

public class OlapBuilderGoogleBigqueryConnection extends OlapBuilderGoogleApiConnection<BigQuery, OlapBuilderGoogleBigqueryDataSource>
{
    private Credentials credentials;

    public OlapBuilderGoogleBigqueryConnection(OlapBuilderGoogleBigqueryDataSource dataSource)
    {
        super(dataSource);
    }

    @Override
    protected BigQuery buildClient(HttpRequestInitializer initializer, HttpTransport httpTransport, JsonFactory jsonFactory)
    {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public Credentials getCredentials()
    {
        return credentials;
    }

    @Override
    public BigQuery getJsonClient()
    {
        return super.getJsonClient();
    }

    public BigQuery createJsonClientForDiscover()
    {
        final String projectId = getDataSource().getProjectId();

        return BigQueryOptions.newBuilder()
                .setCredentials(credentials)
                .setProjectId(projectId)
                .build()
                .getService();
    }

    @Override
    public void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException
    {
        try
        {
            IcCubeRequest.assertNotCancelled("add-member") /* speed-up cancel processing */;

            // Authorization.
            credentials = authorize(context);

            final String projectId = getDataSource().getCredentialsProjectId();

            jsonClient = BigQueryOptions.newBuilder()
                    .setCredentials(credentials)
                    .setProjectId(projectId)
                    .build()
                    .getService();

        }
        catch (Exception ex)
        {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, ex.getMessage());
        }
    }

    @Override
    public String getAccountScope()
    {
        return BigqueryScopes.BIGQUERY;
    }
}
