/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.loggers.OlapLoggers;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;

public class OlapBuilderGoogleBigQueryStorageStreams
{
    private final String tableNameQ;

    private final ArrowSchema schema;

    private final ServerStream<ReadRowsResponse>[] streams;

    private int createdStreamCount;

    private int closedStreamCount;

    private OlapBuilderGoogleBigQueryStorageStream currentStream;

    private int currentStreamIdx;

    public OlapBuilderGoogleBigQueryStorageStreams(String tableNameQ, ArrowSchema schema, ServerStream<ReadRowsResponse>[] streams)
            throws IOException
    {
        this.tableNameQ = tableNameQ;
        this.schema = schema;
        this.streams = streams;

        if (streams.length > 0)
        {
            this.currentStreamIdx = 0;
            this.currentStream = new OlapBuilderGoogleBigQueryStorageStream(
                    this, "0", streams[0]
            );
        }
        else
        {
            this.currentStreamIdx = -1;
            this.currentStream = null;
        }
    }

    public String getTableNameQ()
    {
        return tableNameQ;
    }

    public ArrowSchema getSchema()
    {
        return schema;
    }

    public void incrementCreatedStreamCount()
    {
        createdStreamCount++;
    }

    public void incrementClosedStreamCount()
    {
        closedStreamCount++;
    }

    @Nullable
    public IOlapBuilderTableRow nextRow()
            throws IOException
    {
        while (currentStream != null)
        {
            final IOlapBuilderTableRow row = currentStream.nextRow();

            if (row != null)
            {
                return row;
            }

            if (++currentStreamIdx < streams.length)
            {
                currentStream.close();
                currentStream = new OlapBuilderGoogleBigQueryStorageStream(
                        this, String.valueOf(currentStreamIdx), streams[currentStreamIdx]
                );
            }
            else
            {
                currentStream.close();
                currentStream = null;
            }
        }

        return null;
    }

    public void close()
    {
        if (currentStream != null)
        {
            currentStream.close();
            currentStream = null;
        }

        OlapLoggers.BUILDER_GOOGLE.debug("[big-query-storage] table [" + getTableNameQ() + "] closed session current stream: " + currentStreamIdx + " [stream-count:" + streams.length + "]");

        for (int ii = currentStreamIdx + 1; ii < streams.length; ii++)
        {
            streams[ii].cancel();
        }

        OlapLoggers.BUILDER_GOOGLE.debug("[big-query-storage] table [" + getTableNameQ() + "] closed session streams:" + streams.length + " [" + createdStreamCount + "][" + closedStreamCount + "]");
    }

}
