/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;

public class OlapBuilderGoogleBigQueryStorageStreamResponse
{
    private final OlapBuilderGoogleBigQueryStorageStream stream;

    private final OlapBuilderGoogleBigQueryStorageArrowResponseDecoder decoder;

    public OlapBuilderGoogleBigQueryStorageStreamResponse(OlapBuilderGoogleBigQueryStorageStream stream, ArrowSchema schema, ReadRowsResponse response)
            throws IOException
    {
        this.stream = stream;
        this.stream.incrementCreatedDecoderCount();

        this.decoder = new OlapBuilderGoogleBigQueryStorageArrowResponseDecoder(
                schema, response.getArrowRecordBatch()
        );
    }

    @Nullable
    public IOlapBuilderTableRow nextRow()
    {
        final IOlapBuilderTableRow row = decoder.nextRow();
        return row;
    }

    public void close()
    {
        this.stream.incrementClosedDecoderCount();

        decoder.close();
    }

}
