/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.googleapi.authorization;

import com.google.auth.oauth2.GoogleCredentials;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;

/**
 * This authorization is based in a file.
 *
 * It's not bound to any computer/server and don't need any user interactiona anymore
 */
public class GoogleCredentialServiceAccountBuilder implements OlapBuilderGoogleCredentialBuilder
{
    protected String serviceAccountKeyFile;

    public GoogleCredentialServiceAccountBuilder(String serviceAccountKeyFile)
    {
        this.serviceAccountKeyFile = serviceAccountKeyFile;
    }

    @Override
    public GoogleCredentials authorize(OlapRuntimeContext context, String googleScope) throws GeneralSecurityException, IOException
    {
        final File trusted = context.getUserDefinedFile(serviceAccountKeyFile);

        // Load credentials from the JSON key file
        GoogleCredentials credentials = GoogleCredentials
                .fromStream(new FileInputStream(trusted))
                .createScoped(Collections.singleton(googleScope));

        return credentials;

    }
}
