## Localization

This section describes how to localize MDX entities.

### Localize Dimensions, Hierarchies, Levels and Measures

All the captions in MDX are defined and localized using a localization table. This table can be of
any type (e.g., in-memory, DB, CSV, Excel file, ...). This table contains string columns: the first column contains
the MDX unique names to localize and the remaining columns contains the localized captions of the referenced MDX-entities. The name of the localized caption columns must correspond to a [JAVA locale name](../../mdx/icCubeLanguages.md).
As an example the following table is localizing in French and English several dimensions and show how to localize as
well for a given country (United States and England). Note that when no localized value is available the name is used
as caption.

```
unique_name , fr      , en      , en_US  , en_GB
[País]      , Pays    , Country ,        ,
[Color]     , Couleur , Color   , Color  , Colour
```

**Description**

On top of the captions, a localization table can be used to define and localize the descriptions of any MDX entity.
Simply append the `.description` string at the end of the unique names :

```
unique_name, en, fr      
[Geography].description, "Hierarchical structure organizing geographic data: country, region, city, location.", "Structure hiérarchique organisant les données géographiques : pays, région, ville, emplacement."
```


### Generate a template

The Schema Builder allows for generating a template of this table that contains all the entities unique names 
and names to localize. This template contains both the `UNIQUE_NAME` and `NAME` columns. The `NAME` column allows
to easily identify the members when their keys used and the `UNIQUE_NAME` column are opaque:

```
UNIQUE_NAME,     NAME
[Country].&[12], France
[Country].&[13], Spain
```

There is no need to remove this column when generating your own localization table as it is ignored by the schema
builder.

### Localize ENUM Fields

If you have a level with enum members, then you can use the localization system to show the name for the enum. For example, in the `Questionaire` dimension you have `0`: good, `1`: neutral, `2`: bad. Then in the localization file, you set: 
```
UNIQUE_NAME,                       en
[Questionaire].[Questionaire].[0], good
[Questionaire].[Questionaire].[1], neutral
[Questionaire].[Questionaire].[2], bad
```

Note that normally, the fallback is the name of the member. This means that here the fallback is to the enum value. That is not what you want. You can set the default fallback language in the builder.

![fallback_lang.png](img/fallback_lang.png)

### Localize Members from the Data Source

MDX member captions are localized using [custom member properties](../../mdx/Member%20Custom%20Property.md).
The pre-defined names of those properties are : `@MC_language_country` (country being optional). The language
and country names are following [JAVA locale naming](../../mdx/icCubeLanguages.md):

| Name        | Description                                                             |
|-------------|-------------------------------------------------------------------------|
| `@MC_fr`    | is defining the member captions attached to the French language locale. |
| `@MC_fr_FR` | is defining the member captions attached to the France locale.          |
| `@MC_fr_CA` | is defining the member captions attached to the (French) Canada locale. |

### XMLA Language Identifiers

XMLA is supporting locales
using [language identifiers](http://msdn.microsoft.com/en-us/library/dd318693%28VS.85%29.aspx).
icCube is keeping as much as possible a mapping between JAVA locales and language identifiers.
See this [page](../../mdx/icCubeLanguages.md) for more information about this mapping.

### Walkthrough

For a concrete working example please have a look to the following [page](../walkthrough/walkthrough_localization.md)
that demonstrates how to localize MDX entities (dimensions, hierarchies, levels, members, sets, etc...).

Next chapter: [Deploying](./deployment.md) a schema.

_
