## Facts Overview (Cubes, Measure Groups and Measures)

Before describing how to create some measures (aka. facts), you might want to have a look at this quick
[introduction](facts_intro.md) describing facts and their links to the dimensions.

Here is a quick jump to the [types of aggregations](facts_aggregation.md) available in icCube.

We're going to start by creating a cube and its associated measure groups and measures. A cube is the known MDX
concept that we find in the MDX query language (`SELECT ... FROM [Cube Name]`). Measure groups match exactly a data
table and contain a list of measures. Measures are the known MDX concept and map a scalar value as temperature,
quantity or amount.

### Walkthrough

Let's create our first cube.

#### 1 - Create a Cube

![create cube](img/walk-facts_stand_cube_large.png)

A cube is simply a container of measure groups (aka., facts).

#### 2 - Create a Measure Group:

![create measure group](img/walk-facts_stand_fact_large.png)

`Measure Group Name` : the name of the measure group.

`Data Table`:  matches the data source table defining the measures and their links.

`Dimensions/Facts Links`: associates the table fact columns with the dimensions. The 'link type' defines the type
of association between the dimension and the fact table. You might use the wizard button in the top of the use case
that will resolves link with type `Not Specified` with a best effort strategy.

`Data Table Aggregation` : default value should only be changed if really needed as the other methods might slow
down significantly load operation. It defines how the rows coming from the table are aggregated into icCube internal
structures. Note, this aggregation is independent of the aggregation defined at measure level. For example,
`Sum rows on Cell` will sum all rows that define the same cell. Same cells are rows with the same mapped dimension
id's.

`Unresolved Rows` : used when real-time or incremental load is active. Defines how fact rows with dimension id's that
could not be resolved are managed. As the dimension table is loaded before the facts, it's possible for the fact
table to reference a dimension id that is not yet loaded. Check [here](facts_dim_facts_consistency.md) for more
information.

`Partitioning Type` & `Partitioning Level` :  defines the strategy for partitioning if active.

The list of link types (`Dimensions/Facts Links`) is as following :

`Last Level` : this is the default behaviour. Links with the last level of the main/base hierarchy of the dimension.

`Any Level` : links with all levels of the base hierarchy of the dimension. Common in parent/child dimensions.

`Intermediate Level` : links with an intermediate level of the base hierarchy.

`List of Levels` : links with a list of levels of the base hierarchy. Check [here](facts_multilevels.md) for more
information.

`Many-2-Many` : links the dimension through a many-2-many relation. Check the following pages for more information:
[Facts: Many-2-Many (Bridges)](facts_many2many_bridges.md) and [Facts: Many-2-Many (Arrays)](facts_many2manyArray.md).

`Range (From-To)` : allows to link a single row for each id between from and to (both included). This will create
a many-to-many relation, a fact row is NOT created for each id of the range.

`Not Mapped` : this dimension is not mapped for this measure group.

`Unspecified` : the dimension link has not been defined (e.g. new dimension has been added).

### Create Measures

We're mainly done, let's add a bunch of measures :

![measures](img/walk-facts_stand_dim_large.png)

`Name` : is the name we want to give to the measure and can contain whitespaces. The name used in MDX statements.

`Column` : defines the table column defining the measure.

`Aggregation Type` : defines the aggregation type. The next page explains in details the different options.

`Rollup Hierarchy` : is only needed for certain aggregation types (open, close, average over children...).

`Cell Properties` : matches the MDX measure cell properties.

### Validate & Deploy

Eventually validate our schema and then deploy :

![validate schema](img/walk-facts_stand_validation_large.png)

### Download

The schema of all fact examples is available for download [here](data/Walkthrough_Facts.zip).

Next chapter: [Facts Aggregation Types](facts_aggregation.md) explains the different aggregation types.

_
