## Facts Multiple Levels

In the previous examples we have been associating facts with leaf or terminal members. Even though this is
the classical solution it is possible to associate fact data with any level of a main hierarchy.

This might be relevant in different scenarios. One possible scenario is related to the time dimension :
some values are available at month level, for example exchange rates, and others at day level : sales deals.
This can be done by linking facts with the key of an intermediate level; in icCube it's not mandatory to link
measures to the leaf levels of the dimensions.

Another scenario is an example where data is also linked to intermediate members. Taking our sales example,
intermediate members, `[John]`, is also selling products.

The `[Employees]` dimension is a parent/child dimension so there is no need to do anything additional. Fact tables
need to define data for the intermediate members. If our dimension is a multi-hierarchy one, we need to add the keys
for all levels we want to link with the facts. Note, you need to ensure the key values are unique across levels in
order to avoid unexpected results.

After deploying the cube and running the query we can see the employees hierarchy is no longer an aggregation of leafs
members. Sales amount for `[John]` includes his own sales (`1`) and the sales of `[Emily]` and `[Paul]` (`10`).

![multi-level](img/walk-facts_multilevel_large.png)

### Download

The schema of all fact examples is available for download [here](data/Walkthrough_Facts.zip).

Next chapter: [Facts No Aggregation](facts_noaggreg.md) shows how to create hierarchies that do not aggregate data.

_

