## Facts: Many-2-Many (Arrays)

It's possible to define in all data source tables an array as the type for a table column. The main use of
this type is for defining direct many-to-many relations.

### Walkthrough

The first point is creating a data table with a column of arrays (you have to use `;` in the array if the `,`
is used for column separation) :

```
year        , amount
[2006;2007] ,    100
[2008;2007] ,   1600
2008        ,    200
2007        ,    400
2006        ,    800
```

The two first entries define an array of integers. We will need to add to the year column definition the flag
to tell icCube the column is an array of primitive types.

After this we can create our dimensions and facts the same we do for other cases. When associating our fact table
with the dimension `year`, the icCube engine will automatically create a many-2-many relation for all `year` members
of the array.

Eventually, we can deploy the cube and run the following query to see the result :

```
SELECT
    [Measures].members ON 0,
    [Year].members ON 1
FROM [Cube]
```

![array](img/walk-facts_m2m_array_large.png)

You can see, how the amount `100` is on both `2006` and `2007` years, `1600` on both `2007` and `2008`, but both
are only aggregated once for the `[All]` member. Counts is counting the rows for each MDX tuple.

### Download

The schema of all fact examples is available for download [here](data/Walkthrough_Many-to-Many_Array.zip).

Next chapter: [Facts Multiple Levels](facts_multilevels.md) shows how to associate data to non-terminal members.

_