## Facts Dimension/Facts Consistency

Building a cube is mainly performed in two steps :

* read and process the **dimension tables** to build the dimensions,
* read and process the **facts tables** to build the facts.

The second steps requires that the members referenced by the facts are known to icCube. This is not an issue
if the dimension and facts tables are read-only while icCube is performing the both steps. But consistency
issues might arise as soon as new members and facts are added to these tables while icCube is reading and
processing the facts tables. In that case, the tables are consistent (i.e., facts tables are referencing
existing members in dimension tables) but icCube does not know yet about the newly added members. Therefore,
a missing member key error is generated.

### Incremental Load Comes to the Rescue

To address this issues, incremental load is going to be used.

The idea is to save into an internal buffer facts rows that cannot be resolved while reading the facts
and delay their actual processing until the next incremental load occurs. Indeed, during the next incremental
load icCube will read first the new members and update accordingly the dimensions. Then the previously
unresolved facts rows can be resolved and processed as usual. Eventually optional new facts (incrementally
loaded) are processed as usual and possibly new unresolved rows can be generated again and saved into an
internal buffer waiting for the next incremental load.

Doing this way, icCube is seeing sort of consistent snapshots of the underlying tables. Note that it is
assumed that the underlying tables are always consistent (i.e., facts are referencing existing members via
foreign key for example). Here we're addressing instead inconsistencies created because of the existing delay
between dimension and facts tables processing.

Note, you can simply ignore unresolved rows if no incremental load is activated. The schema statistics
will indicate how many rows have been ignored while processing the facts. This might be fine for your
use case.

### Advanced Property : Unresolved Rows

This (measure groups) advanced property determines how facts rows referencing unknown members are processed :

| Strategy                            | Description                                                           |
|-------------------------------------|-----------------------------------------------------------------------|
| Generate An Error                   | The default behavior is to generate an error.                         |
| Ignore Them                         | Simply ignored (statistics about them are kept at schema level).      |
| Keep Them for Next Incremental Load | Keep the rows in-memory until the next incremental load process them. |

![unresolved rows](img/unresolved_rows_large.png)

The configuration property `maxUnresolvedRowsCount` (see [icCube.xml](../configuring_iccube/iccube_xml.md))
controls the maximum number of rows per facts table that are kept in memory for processing during the next
incremental load (see the `Unresolved Rows` strategy above).

Next chapter: [Advanced Features](advanced.md).

_