### Facts Aggregation Types

When creating measures (aka. [facts](facts_standard.md)) we need to define their aggregation type. The aggregation type
defines how the engine is going to calculate the measure value. Those calculation, as opposed, to calculated members are
specially optimized for the best performance.

There are several families of measure aggregations in icCube :

- **additive** measures : the aggregation is independent of any hierarchy (e.g., sum).
- **semi-additive** measures : the aggregation requires the definition of a rollup hierarchy to calculate their value.
  E.g., open/close that typically requires a time hierarchy for the rollup.
- **non-additive** measures : the aggregation cannot be performed across all dimensions (e.g., ratios).

Since icCube 9.x, you can define your own [custom aggregation](./facts_custom_aggregation.md) written in Java.
With this, you are able to implement whatever logic is required and even implement an aggregation for **non-additive**
measures.

### Additives Measures : Aggregation Types without Rollup Hierarchy

#### Sum

This is the default aggregation type, all row values are aggregated using the sum operator.

Depending on the value of the property `icCube.mdxSumAlgo` as defined in the file `icCube.xml`,
this sum can be equivalent to the `Sum (high precision)` as described below.

#### Sum (high precision)

All row values are aggregated using the sum operator and the Neumaier summation algorithm to minimize
rounding errors.

If the value of the property `icCube.mdxSumAlgo` as defined in the file `icCube.xml` is `NEUMAIER`
then this aggregation is equivalent to the `Sum` aggregation as defined above.

Since icCube 8.6.2, the default `icCube.xml` is created with the `NEUMAIER` algorithm for the `Sum`.

#### Sum Square

Returns the sum all row `square` value (i.e., `value * value`). Handy for doing statistics: variance, standard
deviation...

#### Min/Max

Returns the minimum or maximum row value.

#### Average (rows)

Returns the average of existing rows (no empty).

#### Count (rows)

Counts the number of rows that are not empty. Pay attention that rows and cells are usually the same but might be
different. You've to set `aggregate facts` field to true in order to aggregate rows by cell, but take care as this
might be time-consuming for large facts during the load phase.

#### Distinct Count

Counts the number of *distinct* (different) row values.

#### Vector

Returns a vector with the row values. If no values, an empty value is returned.

Vectors on comparable values, for example strings, can contain null values. This is not the case for numerical
vectors.

#### Vector Sorted

Returns a vector with the row values sorted. If no values an empty value is returned.

Vectors on comparable values, for example strings, can contain null values. This is not the case for numerical
vectors.

#### Vector Unique

Returns a vector with the unique values. If no values, an empty value is returned. Note that the values are not sorted;
to sort, use the `-> sort()` method.

Vectors on comparable values, for example strings, can contain null values. This is not the case for numerical
vectors.

#### No Aggregation

Returns raw values without aggregating them.

#### Row Numbers

Returns the set of indexes as a string of the corresponding row value. Useful for debugging purposes.

#### Row Numbers (vector)

Returns an array (vector) of indexes of the corresponding row value. Note that the first element of the array is an
internal index. Useful for debugging purposes.

### Semi-Additives Measures : Aggregation Types with Rollup Hierarchy

#### Sum (children)

Returns the sum of non-empty children. This aggregation type needs a rollup hierarchy.

#### Average (Children)

Returns the average of non-empty children. This aggregation type needs a rollup hierarchy.

#### Open

Returns the summed value of the first leaf member in the rollup hierarchy (e.g., first day of a
year). [Example](#openclose-example).

#### Close

Returns the summed value of the last leaf member in the rollup hierarchy (e.g., last day of a
year). [Example](#openclose-example).

#### Open No Empty

Returns the summed value of the first `no empty` leaf member in the rollup hierarchy (e.g., first day of a year
with a value). [Example](#openclose-example).

#### Close No Empty

Returns the summed value of the last `no empty` leaf member in the rollup hierarchy (e.g., last day of a year with a
value). [Example](#openclose-example).

#### Unary Operator (+-*/~)

Redefines the aggregation for the rollup hierarchy depending on the value of a member property (`@uo`). Member
without children, leaf members, are calculated using the Sum aggregation. Member with children are calculated using
the `@uo` property value :

| Operator | Description                                                                                                |
|----------|------------------------------------------------------------------------------------------------------------|
| +        | the value of the member is added to the parent's value                                                     |
| –        | the value of the member is subtracted from the parent's value                                              |
| *        | the value of the member is multiplied by the sum of the previous siblings, and added to the parent's value |
| /        | the value of the member is divided by the sum of the previous siblings, and added to the parent's value    |
| ~        | the value is ignored to calculate the parent's value. But taken into account for `*` and `/` calculations  |

### Open/close example

In the next example, this is the facts table. The rollup hierarchy is a time dimension defined on the date column.

| date       | value     |
|:-----------|:----------|
| 2024-01-01 | 1         |
| 2024-01-01 | 3         |
| 2024-01-02 | 5         |
| 2024-01-03 | 7         |
| 2024-01-04 | _\<null>_ |

The aggregations produce these values:

* `Open` returns 4.
* `Close` returns _\<null>_.
* `Open (No Empty)` returns 4.
* `Close (No Empty)` returns 7.

### Non-Additives Measures

A non-additive measure in OLAP and MDX is a measure that cannot be meaningfully summed (added) across
all dimensions in the cube. Because standard summation produces incorrect or misleading results, such measures
require special handling.

In most cases, the recommended approach is to create calculated measures (or calculated members) in MDX that perform
the correct logic after the additive components have been properly aggregated.

For more advanced scenarios — such as calculating a [median](../../mdx_faq/calculating_median.md) across several
dimensions — custom logic is required.

Starting with icCube 9.x, it is also possible to define fully [custom aggregations](./facts_custom_aggregation.md)
written in Java.

### Download

You can check the different types of aggregations with the fact walkthrough [schema](data/Walkthrough_Facts.zip).
In order to have an overview of the different types you might run the following query :

```
SELECT
    [Measures].members ON 0,
    [Time].[Time].members - [time].[Time].[Month] ON 1  // get rid of the month level in the rollup hierarchy
FROM [Aggr. Type]
```

![aggregations](img/walk-facts_aggr_type_large.png)

For the unary operator aggregation types you can run the following request :

```
WITH
    MEMBER [UO] as [Account Structure].[Account Structure].properties("@UO")
SELECT
    { [UO],[Unary Operator] } ON 0,
    [Account Structure].[Account Structure].members ON 1
FROM [Aggr. Type]
```

![unary aggregation](img/walk-facts_aggr_type2_large.png)

Next chapter: [Facts Custom Aggregation)](./facts_custom_aggregation.md) shows how to create your own
fact aggregation.

_
