## JSON Files

It's possible to use files in JSON format as datasources. You can import files located on icCube Server drives
as well as files located in an HTTP server (using possibly `HTTP Basic Authentication`).

Note that icCube Server allows to define a root path for the local drive the user will have access to
(`fileSystemRoot` in [icCube.xml](../configuring_iccube/iccube_xml.md)). This will forbid icCube users
to see the whole server file system.

JSON format is assumed to be in an array of object format. You can define a 'root' that is used to find the array
in the file holding the information we want to convert in a table.

```
{
    payload :
    {
        stream : [
            { temp : 22, date : 1582635652 },
            { temp : 21, date : 1582546652 },
            ...
            { temp : 19, date : 1580546652 },
        ]
    }
}
```

You would define the root as `payload.stream` (dates are defined in [Epoch format](https://www.epochconverter.com/)).
Without a root the file should start with an array to have multiple rows.

![JSON](img/ds_json_large.png)

### Download

A demo schema is available for download [here](data/Walkthrough_Json_.icc-schema).

Next chapter: [Hadoop (Impala/Hive)](ds_hadoop.md) details a data source connecting to Hadoop/Impala.

_
