## Google BigQuery, Drive and Analytics

Google provides with a set of cloud services that can be used as icCube data sources.

### Google BigQuery

A connection to a BigQuery project can be used to retrieve tables and perform queries. This is similar
to an SQL data source, just with a different query syntax. You can find more information on the
[web](https://developers.google.com/bigquery).

### Google Drive

It's possible to use a Google Spreadsheet as an icCube's data source. It works similar to an Excel sheet,
after selecting a spreadsheet each sheet is represented as a different data table.

### Google Analytics

It's also possible to use Google Analytics as a data source. You'll have to combine dimensions and metrics to query
Google Analytics, you can check [online](https://developers.google.com/analytics/devguides/reporting/core/dimsmets)
for more information.

### Authentication

Google API provides several ways to handle authentication : icCube supports the Service Account (no need for storing
the user and password). You'll need to create in [Google API Console](https://code.google.com/apis/console) a Service
Account. In the console navigate to APIs & auth/Register App and create Web application. Keep the generated private
key as it's used by icCube to authenticate the service. Do not forget you'll have to grant the created user with
required authorizations (e.g. access to Google Analytics).

Next chapter: [MongoDB](ds_mongodb.md) describes how to use the MongoDB datasource.

_
