## Relational Database

Relational databases are the typical way of creating a schema. It should be noted (as with any other type
of data source available) that there's no limitation to the number of database sources used when creating a schema.
Data from different databases can be merged to create such a schema.

Any datasource with a JDBC driver can be used in icCube (e.g., Oracle, SQL Server, MySQL, Postgres, Sybase ASE, 
Amazon Redshift, Amazon Athena, ...). If you do not find support for your DB server, please do not hesitate to
[contact us](https://www.iccube.com/contact-us/).

### Environment Variables

Several fields of the definition of the JDBC datasources can reference
an [environment variable](../configuring_iccube/env_variables.md#schema-definition) or a
[JAVA system property](../configuring_iccube/jre_options.md#schema-definition).

- URL
- Server Name
- DB Name / Catalog
- User/Password
- Additional Driver Properties (aka. URL Parameters)

Note that the user's password can be encrypted. Please [contact us](https://www.iccube.com/contact-us/) for more
details.

### Array Data Type

The array data type, if supported (e.g. Oracle and Postgres), is directly integrated into icCube
for building many-to-many relations (see [m2m facts](../schemas_cubes/facts_many2manyArray.md)).

### Table vs. View

You can use an existing table or view as well as define your own SQL queries as a data source table.

### Reporting Visibility

This kind of datasource can be directly accessed from the reporting application for writing SQL queries
inside any dashboard. Remember that a **schema does not need to contain any cube to be successfully loaded**. 
So you can create a schema containing several datasources for reporting usage only and have it automatically
loaded.

Next chapter: [Files](ds_files.md) details data sources made of one or more files.

_
