## Indexing by Range Dimension (Many-2-Many)

Please refer to this [page](../../mdx_tutorial/dimensions.md) for a quick introduction of the dimension concept.

### Overview

The former help page showed how to associate a single member with a continuous value. In this page we're going to
show an extension that allows to associate a fact row with multiple members (similar to many-to-many relation).
The first step consist in defining two key values (e.g. one for start and another for end). Then, all members
that belong to the range `[start, end]` will be associated with the same fact row. This, as for a many-to-many
relation, breaks the natural hierarchical aggregation (a parent might be not anymore the sum of his children
as the same row might be associated with different children).

### Walkthrough

Let's work through an example. We'll create a shipping order table with both an order and a shipping date.
This is inspired by Chris Webb
[example](http://cwebbbi.wordpress.com/2011/01/21/solving-the-events-in-progress-problem-in-mdx-part-1/) :

```
Id, Customer, Order Date, Ship date
1,  John,     01/01/2013, 06/01/2013
2,  Grace,    03/01/2013, 04/01/2013
2,  Grace,    04/01/2013, 05/01/2013
3,  Paul,     06/01/2013, 12/01/2013
4,  Paul,     30/01/2013, 02/02/2013
5,  Pierre,   01/02/2013, 06/02/2013
6,  Lidia,    04/02/2013, 06/02/2013
7,  Grace,    07/02/2013, 09/02/2013
8,  John,     10/02/2013, 11/02/2013
9,  Pierre,   13/02/2013, 14/02/2013
```

Our goal is to calculate the number of open orders for each day. First we need to create the dimensions
`Customer` and `Calendar` (don't forget the indexing by range option). Once done, we'll create our cube
and, it's in the `Facts definition` that the difference is made : instead of linking our dimension with
a single column, we will do it with both `Order Date` and `Ship date` columns. They will define the start
and the end. Note that both dates will be included in our range.

![range facts](img/walk-dim-range-2-fact_large.png)

After deploying the schema we can run the following MDX :

```
 SELECT
    NON EMPTY [Calendar].[Calendar].[Day] ON 1,
    [Customer].[Customer].members  ON 0
 FROM [Cube]
```    

We can see how the result show the expected values :

![range result](img/walk-dim-range-2-res_large.png)

The `[Calendar]` dimension behaves as a many-to-many one. In order to better understand the differences you can run
the following MDX statement and check the difference between icCube's aggregation and a calculated measure that has
been defined as the sum of the days :

```
SELECT
    {([Measures].[Open Orders]),([Measures].[Sum Daily Open Orders])} on 0,
    Non empty {[Calendar].[Calendar].[Quarter].&[2013-01-01].children} on 1
FROM [Cube]
```

The difference is that the `[Open Orders]` measures aggregates over rows without adding twice the same one.
On the other hand, the calculated measure is going to add for each day, therefore adding several times the
same fact row.

### Download

The schema of this example is available for download [here](data/Walkthrough_Ranged2.zip).

Next chapter: [Many-to-Many](dim_many2many.md).

_
